/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/


package cnrg.itx.datax.client;

import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import java.io.*;
import java.net.*;

/**
 * This class tests audio streaming over the network.  This sample routine uses a NetworkSource
 * and SpeakerDestination to play audio originating from a NetworkServer.  Note that in creating 
 * the various destinations and sources, the remote source/destination sample size MUST equal the 
 * local source/destination sample size.
 * <p>
 * Usage: jview cnrg.itx.datax.devices.NetworkClient
 * 
 * @author Jason Howes
 * @version 1.1, 3/6/1999
 * @see cnrg.itx.datax.Channel
 * @see cnrg.itx.datax.devices.StreamSource
 * @see cnrg.itx.datax.devices.NetworkDestination
 * @see cnrg.itx.datax.devices.NetworkSource
 * @see cnrg.itx.datax.devices.SpeakerDestination
 */
class NetworkClient
{	
	public static int PORT = 7777;
	
	public static void main(String []args)
	{	
		try
		{
			
			// Input channel, source, and destination
			Channel inChannel = new Channel();
			NetworkSource inSource = new NetworkSource(inChannel, SpeakerDestination.SAMPLE_SIZE);
			SpeakerDestination inDest = new SpeakerDestination();
			
			// Set input channel
			inChannel.setSource(inSource);
			inChannel.addDestination(inDest);
			
			// Start destination
			inChannel.open();
			
			// Let the audio file play...
			System.out.println("Playing audio from the network...");
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
	}
}
